$(document).ready(function() {
    // Handle form submission
    $('#saveUser').click(function() {
        const formData = {
            username: $('#addUserForm input[name="username"]').val(),
            password: $('#addUserForm input[name="password"]').val(),
            role: $('#addUserForm select[name="role"]').val(),
            protopopiat: $('#addUserForm input[name="protopopiat"]').val(),
            parohie: $('#addUserForm input[name="parohie"]').val()
        };

        $.ajax({
            url: 'api/users.php',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(formData),
            success: function(response) {
                if (response.success) {
                    $('#addUserModal').modal('hide');
                    location.reload();
                }
            },
            error: function(xhr) {
                alert('Error: ' + xhr.responseJSON.error);
            }
        });
    });

    // Handle user deletion
    $('.delete-user').click(function() {
        if (confirm('Sunteți sigur că doriți să ștergeți acest utilizator?')) {
            const userId = $(this).data('id');
            
            $.ajax({
                url: 'api/users.php?id=' + userId,
                method: 'DELETE',
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    }
                },
                error: function(xhr) {
                    alert('Error: ' + xhr.responseJSON.error);
                }
            });
        }
    });

    // Clear form when modal is closed
    $('#addUserModal').on('hidden.bs.modal', function() {
        $('#addUserForm')[0].reset();
    });
});
