-- Create the database if it doesn't exist
CREATE DATABASE IF NOT EXISTS arb00;
USE arb00;

-- Create users table
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    role ENUM('admin', 'paroh', 'protopop', 'cimitir', 'inventar') NOT NULL,
    protopopiat VARCHAR(100),
    parohie VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default admin user (password: admin123)
INSERT INTO users (username, password, role) VALUES 
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin')
ON DUPLICATE KEY UPDATE role = 'admin';

-- Create protopopiate table
CREATE TABLE IF NOT EXISTS protopopiate (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nume VARCHAR(100) NOT NULL UNIQUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Create parohii table
CREATE TABLE IF NOT EXISTS parohii (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nume VARCHAR(100) NOT NULL,
    protopopiat_id INT NOT NULL,
    adresa TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (protopopiat_id) REFERENCES protopopiate(id),
    UNIQUE KEY unique_parohie_proto (nume, protopopiat_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Create inventar table
CREATE TABLE IF NOT EXISTS inventar (
    id INT AUTO_INCREMENT PRIMARY KEY,
    parohie_id INT NOT NULL,
    denumire VARCHAR(255) NOT NULL,
    descriere TEXT,
    cantitate INT NOT NULL DEFAULT 1,
    valoare DECIMAL(10,2),
    data_achizitie DATE,
    stare ENUM('nou', 'bun', 'deteriorat', 'necesita_reparatii', 'casat') NOT NULL DEFAULT 'nou',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (parohie_id) REFERENCES parohii(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Create cimitir table
CREATE TABLE IF NOT EXISTS cimitire (
    id INT AUTO_INCREMENT PRIMARY KEY,
    parohie_id INT NOT NULL,
    nume VARCHAR(100) NOT NULL,
    adresa TEXT,
    suprafata DECIMAL(10,2), -- in metri patrati
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (parohie_id) REFERENCES parohii(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Create morminte table
CREATE TABLE IF NOT EXISTS morminte (
    id INT AUTO_INCREMENT PRIMARY KEY,
    cimitir_id INT NOT NULL,
    parcela VARCHAR(50),
    rand INT,
    numar INT,
    titular VARCHAR(255),
    decedat VARCHAR(255),
    data_inmormantare DATE,
    data_expirare DATE,
    observatii TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (cimitir_id) REFERENCES cimitire(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
