
import React from 'react';
import { APP_TITLE } from '../../constants.tsx'; // Ensure .tsx

const Header: React.FC = () => {
  return (
    <header className="bg-white shadow-md print:hidden">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8 h-16 flex justify-between items-center">
        <h1 className="text-xl sm:text-2xl font-semibold text-sky-700">{APP_TITLE}</h1>
        {/* Placeholder for user profile/logout */}
        <div className="flex items-center">
          {/* Example: User avatar, can be replaced with actual user data later */}
          <span className="text-sm text-slate-600 mr-2 hidden sm:inline">Utilizator Local</span>
          <img 
            src="https://ui-avatars.com/api/?name=User&background=0ea5e9&color=fff&size=128" // Sky blue avatar
            alt="User Avatar" 
            className="w-8 h-8 sm:w-10 sm:h-10 rounded-full object-cover"
          />
        </div>
      </div>
    </header>
  );
};

export default Header;
