
import React from 'react';

interface InputProps extends React.InputHTMLAttributes<HTMLInputElement | HTMLTextAreaElement> {
  label?: string;
  error?: string;
  containerClassName?: string;
  as?: 'input' | 'textarea'; // To allow for textarea variant
  rows?: number; // For textarea
}

const Input: React.FC<InputProps> = ({ 
  label, 
  name, 
  error, 
  containerClassName = '', 
  className = '', 
  as = 'input',
  rows = 3,
  ...props 
}) => {
  const baseClasses = "block w-full px-3 py-2 border border-slate-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-sky-500 focus:border-sky-500 sm:text-sm disabled:bg-slate-50 disabled:text-slate-500 disabled:cursor-not-allowed";
  const errorClasses = "border-red-500 focus:ring-red-500 focus:border-red-500";
  const Element = as;

  return (
    <div className={`mb-4 ${containerClassName}`}>
      {label && (
        <label htmlFor={name} className="block text-sm font-medium text-slate-700 mb-1">
          {label}
        </label>
      )}
      <Element
        id={name}
        name={name}
        rows={as === 'textarea' ? rows : undefined}
        className={`${baseClasses} ${error ? errorClasses : ''} ${className}`}
        {...(props as any)} // Type assertion needed due to dynamic element type
      />
      {error && <p className="mt-1 text-xs text-red-600">{error}</p>}
    </div>
  );
};

export default Input;
