
import React from 'react';
import { DropdownOption } from '../../types.tsx'; // Ensure .tsx

interface SelectProps extends React.SelectHTMLAttributes<HTMLSelectElement> {
  label?: string;
  error?: string;
  options: DropdownOption[];
  containerClassName?: string;
  placeholderOption?: string; // Optional custom placeholder text
}

const Select: React.FC<SelectProps> = ({ 
  label, 
  name, 
  error, 
  options, 
  containerClassName = '', 
  className = '', 
  placeholderOption,
  ...props 
}) => {
  const baseClasses = "block w-full pl-3 pr-10 py-2 border border-slate-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-sky-500 focus:border-sky-500 sm:text-sm disabled:bg-slate-50 disabled:text-slate-500 disabled:cursor-not-allowed";
  const errorClasses = "border-red-500 focus:ring-red-500 focus:border-red-500";
  
  return (
    <div className={`mb-4 ${containerClassName}`}>
      {label && (
        <label htmlFor={name} className="block text-sm font-medium text-slate-700 mb-1">
          {label}
        </label>
      )}
      <select
        id={name}
        name={name}
        className={`${baseClasses} ${error ? errorClasses : ''} ${className}`}
        {...props}
      >
        <option value="">{placeholderOption || `Selectați ${label || 'o opțiune'}...`}</option>
        {options.map(option => (
          <option key={option.value.toString()} value={option.value}>
            {option.label}
          </option>
        ))}
      </select>
      {error && <p className="mt-1 text-xs text-red-600">{error}</p>}
    </div>
  );
};

export default Select;
