
import React from 'react';
import { TableColumn } from '../../types.tsx'; // Ensure .tsx

interface TableProps<T> {
  columns: TableColumn<T>[];
  data: T[];
  getKey: (item: T) => React.Key;
  caption?: string;
}

const Table = <T extends object,>(
  { columns, data, getKey, caption }: TableProps<T>
): React.ReactElement => {
  
  return (
    <div className="overflow-x-auto bg-white shadow-lg rounded-lg border border-slate-200">
      <table className="min-w-full divide-y divide-slate-200">
        {caption && (
          <caption className="p-4 text-lg font-semibold text-left text-slate-700 bg-slate-50 rounded-t-lg">
            {caption}
          </caption>
        )}
        <thead className="bg-slate-100">
          <tr>
            {columns.map((col) => (
              <th
                key={String(col.key)}
                scope="col"
                className="px-5 py-3 text-left text-xs font-medium text-slate-600 uppercase tracking-wider"
              >
                {col.header}
              </th>
            ))}
          </tr>
        </thead>
        <tbody className="bg-white divide-y divide-slate-200">
          {(!data || data.length === 0) ? (
            <tr>
              <td colSpan={columns.length} className="px-6 py-10 text-center text-slate-500">
                Nu sunt date disponibile.
              </td>
            </tr>
          ) : (
            data.map((item) => (
              <tr key={getKey(item)} className="hover:bg-slate-50 transition-colors duration-150 ease-in-out">
                {columns.map((col) => (
                  <td
                    key={`${String(col.key)}-${getKey(item)}`}
                    className="px-5 py-3 whitespace-nowrap text-sm text-slate-700"
                  >
                    {col.render ? col.render(item) : String(item[col.key as keyof T] ?? 'N/A')}
                  </td>
                ))}
              </tr>
            )))}
        </tbody>
      </table>
    </div>
  );
};

export default Table;
