
import React, { Suspense } from 'react';
import { Routes, Route, Navigate } from 'react-router-dom';
import LoadingSpinner from '../components/shared/LoadingSpinner.tsx'; // Ensure .tsx

// Lazy load pages for better initial load performance
// Crucially, ensure .tsx extension is present for XAMPP/no-bundler setups.
const DashboardPage = React.lazy(() => import('../features/dashboard/DashboardPage.tsx'));
const ProtopopiatePage = React.lazy(() => import('../features/protopopiate/ProtopopiatePage.tsx'));
const UsersPage = React.lazy(() => import('../features/users/UsersPage.tsx'));

// Placeholder Pages for sections not yet fully implemented
const PlaceholderPage: React.FC<{ title: string; description?: string }> = ({ title, description }) => (
  <div className="p-6 bg-white shadow-xl rounded-lg h-full flex flex-col items-center justify-center text-center">
    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" strokeWidth={1.5} stroke="currentColor" className="w-16 h-16 text-sky-400 mb-4">
      <path strokeLinecap="round" strokeLinejoin="round" d="M11.42 15.17L17.25 21A2.652 2.652 0 0021 17.25l-5.878-5.878m0 0a3.004 3.004 0 00-4.243-4.243m4.242 4.242L9.88 9.88m3.758-2.47l.005-.006c.028-.028.052-.059.078-.089L15.878 4.5M19.5 4.5L16.5 7.5M3 21l3.004-3.004m0 0A1.5 1.5 0 014.5 16.5V15M6.75 12.75a1.5 1.5 0 00-1.5-1.5H3.75a1.5 1.5 0 00-1.5 1.5v1.5c0 .621.504 1.125 1.125 1.125H5.25M9 15h6m-6-3h6m-6-3h6M3 6h6" />
    </svg>
    <h2 className="text-2xl font-semibold text-slate-700 mb-2">{title}</h2>
    <p className="text-slate-500 max-w-md">{description || 'Această secțiune este în curs de dezvoltare. Conținutul va fi disponibil în curând.'}</p>
    <img src="https://picsum.photos/seed/construction/600/300?grayscale&blur=2" alt="Under Construction" className="mt-6 rounded-md shadow-sm opacity-75"/>
  </div>
);

const ParohiiPage = () => <PlaceholderPage title="Administrare Parohii" />;
const PersonalPage = () => <PlaceholderPage title="Administrare Personal" />;
const InventarPage = () => <PlaceholderPage title="Administrare Inventar" />;


const AppRoutes: React.FC = () => {
  return (
    <Suspense fallback={<LoadingSpinner message="Se încarcă pagina..." size="lg" className="h-full"/>}>
      <Routes>
        <Route path="/" element={<DashboardPage />} />
        <Route path="/protopopiate" element={<ProtopopiatePage />} />
        <Route path="/utilizatori" element={<UsersPage />} /> 
        <Route path="/parohii" element={<ParohiiPage />} />
        <Route path="/personal" element={<PersonalPage />} />
        <Route path="/inventar" element={<InventarPage />} />
        
        {/* Fallback for any other route */}
        <Route path="*" element={<Navigate to="/" replace />} />
      </Routes>
    </Suspense>
  );
};

export default AppRoutes;
