
import { Protopopiat, User, Rol, Parohie, ProtopopiateStatus, UserStatus } from '../types.tsx'; // Ensure .tsx

export const mockProtopopiate: Protopopiat[] = [
  {
    id_proterie: 1,
    denumire: 'Protopopiatul Central',
    cui: '12345670', // Unique CUI
    adresa: 'Str. Libertății Nr. 10, Ap. 1',
    localitate: 'Orașul Principal',
    judet: 'Județul Alfa',
    anul_infiintarii: 1990,
    cod_caen: '9491', // Activități ale organizațiilor religioase
    descr_caen: 'Activități ale organizațiilor religioase conform CAEN Rev. 2',
    observatii: 'Sediul central al protopopiatului. Include birouri administrative.',
    status: ProtopopiateStatus.ACTIV,
  },
  {
    id_proterie: 2,
    denumire: 'Protopopiatul Nord',
    cui: '87654320', // Unique CUI
    adresa: 'Bulevardul Eroilor Nr. 25',
    localitate: 'Orașul Nordic',
    judet: 'Județul Beta',
    anul_infiintarii: 1995,
    cod_caen: '9491',
    descr_caen: 'Activități ale organizațiilor religioase',
    observatii: 'Acoperă parohiile din zona de nord a județului.',
    status: ProtopopiateStatus.ACTIV,
  },
   {
    id_proterie: 3,
    denumire: 'Protopopiatul Sud-Est',
    cui: '11223340', // Unique CUI
    adresa: 'Calea Victoriei Nr. 150',
    localitate: 'Orașul Estic',
    judet: 'Județul Gamma',
    anul_infiintarii: 2000,
    cod_caen: '9491',
    descr_caen: 'Activități religioase și de cult',
    observatii: 'Protopopiat recent reorganizat. Necesită actualizarea datelor de contact.',
    status: ProtopopiateStatus.DEZACTIVAT, // Example of an inactive one
  },
];

export const mockRoluri: Rol[] = [
  { id_rol: 1, nume_rol: 'admin', descriere: 'Administrator global al sistemului' },
  { id_rol: 2, nume_rol: 'protopop', descriere: 'Utilizator cu drepturi la nivel de protopopiat' },
  { id_rol: 3, nume_rol: 'paroh', descriere: 'Utilizator cu drepturi la nivel de parohie' },
  { id_rol: 4, nume_rol: 'cimitir', descriere: 'Administrator responsabil cu gestiunea cimitirelor' },
];

export const mockParohii: Parohie[] = [
    { id_parohie: 1, id_tip_parohie: 1, nume_parohie: 'Parohia Sf. Treime', cui: 'PAROH001', adresa: 'Str. Bisericii Nr. 1A', localitate: 'Orașul Principal', judet: 'Județul Alfa', anul_infiintarii: 1950, email: 'sftreime@email-parohie.ro', telefon: '0232123456', site: 'www.sftreime-parohie.ro' },
    { id_parohie: 2, id_tip_parohie: 2, nume_parohie: 'Parohia Adormirea Maicii Domnului', cui: 'PAROH002', adresa: 'Str. Florilor Nr. 5B', localitate: 'Orașul Nordic', judet: 'Județul Beta', anul_infiintarii: 1972, email: 'adormirea@email-parohie.ro', telefon: '0233789012', site: 'www.adormirea-parohie.ro' },
    { id_parohie: 3, id_tip_parohie: 1, nume_parohie: 'Parohia Sf. Gheorghe', cui: 'PAROH003', adresa: 'Aleea Castanilor Nr. 8', localitate: 'Satul Vechi', judet: 'Județul Alfa', anul_infiintarii: 1888, email: 'sfgheorghe.vechi@email-parohie.ro', telefon: '0232555666', site: null },
];


export const mockUsers: User[] = [
  {
    id_user: 1,
    username: 'admin',
    Nume: 'Admin Principal',
    id_rol: 1, // admin
    last_login: '2024-07-28T10:30:00Z',
    status: UserStatus.ACTIV,
    id_parohie: null,
    id_proterie: null,
  },
  {
    id_user: 2,
    username: 'protopop.central',
    Nume: 'Ion Popescu (Protopop)',
    id_rol: 2, // protopop
    last_login: '2024-07-27T15:45:00Z',
    status: UserStatus.ACTIV,
    id_parohie: null,
    id_proterie: 1, // Protopopiatul Central
  },
  {
    id_user: 3,
    username: 'paroh.sftreime',
    Nume: 'Vasile Ionescu (Paroh)',
    id_rol: 3, // paroh
    last_login: '2024-07-28T08:15:00Z',
    status: UserStatus.ACTIV,
    id_parohie: 1, // Parohia Sf. Treime
    id_proterie: null,
  },
   {
    id_user: 4,
    username: 'user.inactiv',
    Nume: 'Elena Georgescu',
    id_rol: 3, 
    last_login: '2023-01-10T12:00:00Z',
    status: UserStatus.DEZACTIVAT,
    id_parohie: 2, 
    id_proterie: null,
  },
];
