
// Enum definitions based on schema or common usage
export enum ProtopopiateStatus {
  ACTIV = 'activ',
  DEZACTIVAT = 'dezactivat',
}

export enum TipStudiu {
  LICEU = 'Liceu',
  COLEGIU = 'Colegiu',
  CURS_SPECIALIZARE = 'Curs Specializare', // Corrected typo
  LICENTIALE = 'Licentiale',
  MASTERAL = 'Masteral',
  DOCTORAT = 'Doctorat',
}

export enum UserStatus {
  ACTIV = 'activ',
  DEZACTIVAT = 'dezactivat',
}

// Table interfaces
export interface Activitate {
  id_activ: number;
  data_activ: string | null; // DATE maps to string "YYYY-MM-DD"
  nume_activ: string | null;
  descriere: string | null;
  obs_activ: string | null;
  id_persoana: number | null;
}

export interface Biserica {
  id_biserica: number;
  anul_constructie: number | null;
  adresa: string | null;
  localitate: string | null;
  judetul: string | null;
  obs_biserica: string | null;
  id_parohie: number | null;
}

export interface Cimitir {
  id_cimitir: number;
  nume_cimitir: string | null;
  adresa: string | null;
  localitate: string | null;
  judetul: string | null;
  obs_cimitir: string | null;
  id_parohie: number | null;
}

export interface Cladire {
  id_cladire: number;
  nume_cladire: string | null;
  anul_constructie: number | null;
  stare: string | null;
  obs_cladire: string | null;
  id_parohie: number | null;
}

export interface Concesionar {
  id_cesionar: number;
  numele: string | null;
  prenumele: string | null;
  cnp: string; // char(13) NOT NULL
  adresa: string | null;
  localitate: string | null;
  judet: string | null;
  telefon: string | null;
  email: string | null;
  id_loc: number | null;
}

export interface Eveniment {
  id_eveniment: number;
  eveniment: string | null;
  data: string | null; // DATE
  descriere: string | null;
  id_biserica: number | null;
}

export interface Functie {
  id_functie: number;
  nume_functie: string; // NOT NULL
  descriere: string | null;
}

export interface Hram {
  id_hram: number;
  Hram: string | null; // Column name is capitalized
  id_biserica: number | null;
}

export interface Inventar {
  id_inventar: number;
  UnitCultCentrala: string | null;
  id_parohie: number | null;
  Localitate: string | null;
  Denumire: string | null;
  Valoare: number | null; // decimal(10,2)
  NrInventar: string | null;
  DataIntrarii: string | null; // DATE
  AutorProducator: string | null;
  Descriere: string | null;
  UnitateMasura: string | null;
  NrUnitateMasura: number | null;
  Colectia: string | null;
  MaterialTitlu: string | null;
  DimensiuniGreutate: string | null;
  StareConservare: string | null;
  Provenienta: string | null;
  DocumentIntrare: string | null;
  ValoareIntrare: number | null; // decimal(10,2)
  DataIesire: string | null; // DATE
  MotivIesire: string | null;
  DataVerificare: string | null; // DATE
  Observatii: string | null;
  CategorieBun: string | null;
  created_at: string; // TIMESTAMP as string (e.g., ISO 8601)
  updated_at: string; // TIMESTAMP as string
}

export interface LocCimitir {
  id_loc: number;
  zona: string | null;
  rand: string | null;
  observatii: string | null;
  id_cimitir: number | null;
}

export interface Parohie {
  id_parohie: number;
  id_tip_parohie: number | null;
  nume_parohie: string | null;
  cui: string | null;
  adresa: string | null;
  localitate: string | null;
  judet: string | null;
  anul_infiintarii: number | null;
  email: string | null;
  telefon: string | null;
  site: string | null;
}

export interface Personal {
  id_pers: number;
  numele: string | null;
  prenumele: string | null;
  data_nasterii: string | null; // DATE
  cnp: string; // char(13) NOT NULL
  adresa: string | null;
  localitate: string | null;
  judet: string | null;
  loc_nastere: string | null;
  jud_nastere: string | null;
  id_stare_civila: number | null;
  id_functie: number | null;
  data_angajarii: string | null; // DATE
  nr_decizie: string | null;
  data_incetarii_job: string | null; // DATE
  Observatii: string | null;
  id_parohie: number | null;
}

export interface PersStudiu {
  id_studiu: number;
  tip_studiu: TipStudiu | null;
  Institutia: string | null;
  anul_absolvirii: number | null;
  media: number | null; // decimal(4,2)
  id_pers: number | null;
}

export interface Protopopiat {
  id_proterie: number; // Note: Schema uses 'id_proterie'. Consider aliasing or consistency.
  denumire: string | null;
  cui: string | null;
  adresa: string | null;
  localitate: string | null;
  judet: string | null;
  anul_infiintarii: number | null;
  cod_caen: string | null;
  descr_caen: string | null;
  observatii: string | null;
  status: ProtopopiateStatus | null;
}

export interface Rol {
  id_rol: number;
  nume_rol: string; // NOT NULL
  descriere: string | null;
}

export interface StareCivila {
  id_stare_civila: number;
  nume_stare_civila: string; // NOT NULL
  descriere: string | null;
}

export interface TaxaCmt {
  id_taxa: number;
  nume_taxa: string | null;
  data_achitarii: string | null; // DATE
  nr_chitanta: string | null;
  suma: number | null; // decimal(10,2)
  anul: number | null;
  id_cesionar: number | null;
}

export interface TipParohie {
  id_tip_parohie: number;
  nume_tip_parohie: string; // NOT NULL
  descriere: string | null;
}

export interface User {
  id_user: number;
  username: string; // NOT NULL
  password?: string; // Optional: Not usually sent to client unless for creation/update.
  Nume: string | null; // Column name is capitalized
  id_rol: number | null;
  last_login: string | null; // DATETIME as string (e.g., ISO 8601)
  status: UserStatus | null;
  id_parohie: number | null;
  id_proterie: number | null; // Note: Schema uses 'id_proterie'.
}

// For generic table component
export interface TableColumn<T> {
  key: keyof T | 'actions'; // 'actions' is a special key for action buttons column
  header: string;
  render?: (item: T) => React.ReactNode;
}

// For API responses that might involve lists for dropdowns
export interface DropdownOption {
  value: string | number; // Can be string or number depending on use case
  label: string;
}
